
pl8b_name  = 'A-Darter'
pl8b_model = 'a-darter'
pl8b_mass  = 89

PL_8B_AA = {
    category        = CAT_AIR_TO_AIR,    
    name            = pl8b_name,
    --model           = 'PL-8B'
    user_name       = _(pl8b_name),
    wsTypeOfWeapon  = {4,4,7,WSTYPE_PLACEHOLDER},
    Escort          = 0,
    Head_Type       = 1,
    sigma           = {2, 2, 2},
    M               = pl8b_mass,
    H_max = 18000.0,
    H_min = -1,
    Diam = 127.0,
    Cx_pil = 1.88,
    D_max = 28000.0,
    D_min = 200.0,
    Head_Form = 0,
    Life_Time = 240.0,
    Nr_max = 55,
    v_min = 140.0,
    v_mid = 400.0,
    Mach_max = 3.7,
    t_b = 0.0,
    t_acc = 7.0,
    t_marsh = 3.0,
    Range_max = 35000.0,
    H_min_t = 1.0,
    Fi_start = 1.57,
    Fi_rak = 3.14152,
    Fi_excort = 1.57,
    Fi_search = 0.09,
    OmViz_max = 1.10,
    warhead         = enhanced_a2a_warhead(11.0);
    exhaust         = { 0.7, 0.7, 0.7, 0.08 };  
    X_back          = -1.35,     
    Y_back          = -0.1, 
    Z_back          = 0.0,
    Reflection      = 0.0182,
    KillDistance    = 7.0,
    --seeker sensivity params
	SeekerGen = 4,  -- Seeker generation
    SeekerSensivityDistance = 35000, -- The range of target with IR value = 1. In meters.
    ccm_k0                  = 0.02, -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
    SeekerCooled    = true, -- True is cooled seeker and false is not cooled seeker.
	x_wing_anim = -1,
	PN_gain = 6,
	SeekerGen = 4,

    shape_table_data = {
        {
            name     = pl8b_name,
            file     = pl8b_model,
            life     = 1,
            fire     = {0, 1},
            username = pl8b_name,
            index    = WSTYPE_PLACEHOLDER,
        },
    },
	
	supersonic_A_coef_skew = 0.3, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.0068, -- площадь выходного сечения сопла

	ModelData = {   58 ,  -- model params count
		0.35 ,   -- characteristic square (характеристическая площадь)
		
		-- параметры зависимости Сx
		0.04 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.08 , -- Cx_k1 высота пика волнового кризиса
		0.02 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.05, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		1.2 , -- Cx_k4 крутизна спада за волновым кризисом 
		1.0 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
		
		-- параметры зависимости Cy
		1.2 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8	 , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.0  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.5, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.8, -- Alfa_max by trust vectoring
		
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,		   -1.0,	5.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	5.44,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	12802.0,	0.0,	    0.0,			0.0,		0.0,           -- thrust, newtons
		
		1.0e9, -- таймер самоликвидации, сек
		60.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		0.45, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		30.0, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		2.2, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		1.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		9.0, -- производная дальности по скорости носителя на высоте 1км, ППС
		-13.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-2.1, -- производная по высоте производной дальности по скорости цели, ЗПС
		15500.0, -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
		5500.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м 
		27000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		10000.0,  -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		10500.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		3500.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.55, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.01, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	}, 
}

declare_weapon(PL_8B_AA)

declare_loadout({
    category     = CAT_AIR_TO_AIR,
    CLSID        = "{JAS39_A-DARTER}",
    Picture      = "a-darter.png",
    attribute    = PL_8B_AA.wsTypeOfWeapon,   
    displayName  = _(pl8b_name),
    Cx_pil       = 0.00077,
    Count        = 1,
    Weight       = pl8b_mass,
    Elements     = {
        [1] =
        {
            DrawArgs =
            {
                [1] = {1, 1},
                [2] = {2, 1},
            }, -- end of DrawArgs
            Position  = {0, 0, 0},
            ShapeName = pl8b_model,
        },
    }, -- end of Elements
})



declare_loadout({
    category       = CAT_AIR_TO_AIR,
    CLSID          = '{TWIN-R-74M-RIGHT}',
    Picture        = 'r73.png',
    wsTypeOfWeapon = PL_8B_AA.wsTypeOfWeapon,
    attribute      = {4,4,32,WSTYPE_PLACEHOLDER},  
    displayName    = _("2 x R-74M"),
    Cx_pil         = 0.000859765625,
    Count          = 2,
    Weight         = 2*110 + 40,
    Elements       = {
        {
            ShapeName = "lau-105",        
            IsAdapter = true 
        },
        {
            ShapeName = "r-73L",
			Rotation = {0,0,0},
			Position	=	{0.2,	0.03, -0.22},       
          
        },
        {
            ShapeName = "r-73L",
			Rotation = {0,0,0},
			Position	=	{-0.1,	0.03, 0.22},        
            
        },
    },
    JettisonSubmunitionOnly = true,
})




declare_loadout({
    category       = CAT_AIR_TO_AIR,
    CLSID          = '{TWIN-R-74M-LEFT}',
    Picture        = 'r73.png',
    wsTypeOfWeapon = PL_8B_AA.wsTypeOfWeapon,
    attribute      = {4,4,32,WSTYPE_PLACEHOLDER},
    displayName    = _("2 x R-74M"),
    Cx_pil         = 0.000859765625,
    Count          = 2,
    Weight         = 2*110 + 40,
    Elements       = {
        {
            ShapeName = "lau-105",       
            IsAdapter = true 
        },
        {
            ShapeName = "r-73L",
			Rotation = {0,0,0},
			Position	=	{0.2,	0.03, 0.22},     
          
        },
        {
            ShapeName = "r-73L",
			Rotation = {0,0,0},
			Position	=	{-0.1,	0.03, -0.22},        
        },
    },
    JettisonSubmunitionOnly = true,
})

